// // // // // // // // // // // // // // // //
//
//	Enemy Territory - ServerWelt.cc
//
//	erstellt 1.2.98 Andreas Warnke
//	geändert 5.5.98 von Andreas Warnke
//



// // // // // // // // // // // // // // // //
//
//	include:
//

#include "Communicator.h"
#include "Spieler.h"
#include "AsciiKette.h"
#include "Definitions.h"



// // // // // // // // // // // // // // // //
//
//	Konstruktor:
//

Communicator :: Communicator ( unsigned int inMapSize )
	: ZeitWelt ( inMapSize )
{
};



// // // // // // // // // // // // // // // //
//
//	Destruktor:
//

Communicator :: ~Communicator ()
{
	//	Spieler aus Speicher löschen.
	SpielerListe . MakeEmpty ( true );
};



// // // // // // // // // // // // // // // //
//
//	GetAllVisibleFields
//

inline int max ( int x, int y);
int max ( int x, int y)
{
	return ( x > y ) ? x : y;
};

void Communicator :: GetAllVisibleFields (
	int inX,
	int inY,
	int* outX,	//	Feld mit 37 Elementen
	int* outY,	//	Feld mit 37 Elementen
	unsigned int & outCount )
{
	//	Default:
	outCount = 0;
	if ( GetFieldType ( inX, inY ) == FT_EndOfWorld )
		//	Falsche Parameter:
		return;

	//	Numerierung:
	//	  --  36  19  20  21  --  --
	//	--  35  18  07  08  22  --
	//	  34  17  06  01  09  23  --
	//	33  16  05  00  02  10  24
	//	  32  15  04  03  11  25  --
	//  --  31  14  13  12  26  --
	//	  --  30  29  28  27  --  --
	
	int visible [19];
	int Shift = IsShiftRight ( inY );
	int NoShift = 1 - Shift;
	//	Entfernung 0
	//	Feld 0
	visible [0] = 3;
	outX [0] = inX;
	outY [0] = inY;
	//	Entfernung 1
	//	Feld 1
	visible [1] = 3 - GetFieldViewCost ( inX + Shift, inY - 1 );
	outX [1] = inX + Shift;
	outY [1] = inY - 1;
	//	Feld 2
	visible [2] = 3 - GetFieldViewCost ( inX + 1, inY );
	outX [2] = inX + 1;
	outY [2] = inY;
	//	Feld 3
	visible [3] = 3 - GetFieldViewCost ( inX + Shift, inY +1 );	
	outX [3] = inX + Shift;
	outY [3] = inY + 1;
	//	Feld 4
	visible [4] = 3 - GetFieldViewCost ( inX - NoShift, inY +1 );	
	outX [4] = inX - NoShift;
	outY [4] = inY + 1;
	//	Feld 5
	visible [5] = 3 - GetFieldViewCost ( inX - 1, inY );	
	outX [5] = inX - 1;
	outY [5] = inY;
	//	Feld 6
	visible [6] = 3 - GetFieldViewCost ( inX - NoShift, inY - 1);	
	outX [6] = inX - NoShift;
	outY [6] = inY - 1;
	outCount = 7;
	//	Entfernung 2
	//	Feld 7
	int F_Cost = GetFieldViewCost ( inX, inY - 2);	//	FieldCost
	int Money = max ( visible [6], visible [1] );	//	Way Cost
	visible [7] = Money - F_Cost;
	if ( Money > 0 )
	{
		outX [outCount] = inX;
		outY [outCount] = inY - 2;
		outCount ++;
	};
	//	Feld 8
	F_Cost = GetFieldViewCost ( inX + 1, inY - 2);
	Money = visible [1];
	visible [8] = Money - F_Cost;
	if ( Money > 0 )
	{
		outX [outCount] = inX + 1;
		outY [outCount] = inY - 2;
		outCount ++;
	};
	//	Feld 9
	F_Cost = GetFieldViewCost ( inX + 1 + Shift, inY - 1);
	Money = max ( visible [1], visible [2] );
	visible [9] = Money - F_Cost;
	if ( Money > 0 )
	{
		outX [outCount] = inX + 1 + Shift;
		outY [outCount] = inY - 1;
		outCount ++;
	};
	//	Feld 10
	F_Cost = GetFieldViewCost ( inX + 2, inY);
	Money = visible [2];
	visible [10] = Money - F_Cost;
	if ( Money > 0 )
	{
		outX [outCount] = inX + 2;
		outY [outCount] = inY;
		outCount ++;
	};
	//	Feld 11
	F_Cost = GetFieldViewCost ( inX + 1 + Shift, inY + 1);
	Money = max ( visible [2], visible [3] );
	visible [11] = Money - F_Cost;
	if ( Money > 0 )
	{
		outX [outCount] = inX + 1 + Shift;
		outY [outCount] = inY + 1;
		outCount ++;
	};
	//	Feld 12
	F_Cost = GetFieldViewCost ( inX + 1, inY + 2);
	Money = visible [3];
	visible [12] = Money - F_Cost;
	if ( Money > 0 )
	{
		outX [outCount] = inX + 1;
		outY [outCount] = inY + 2;
		outCount ++;
	};
	//	Feld 13
	F_Cost = GetFieldViewCost ( inX, inY + 2);
	Money = max ( visible [4], visible [3] );
	visible [13] = Money - F_Cost;
	if ( Money > 0 )
	{
		outX [outCount] = inX;
		outY [outCount] = inY + 2;
		outCount ++;
	};
	//	Feld 14
	F_Cost = GetFieldViewCost ( inX - 1, inY + 2);
	Money = visible [4];
	visible [14] = Money - F_Cost;
	if ( Money > 0 )
	{
		outX [outCount] = inX - 1;
		outY [outCount] = inY + 2;
		outCount ++;
	};
	//	Feld 15
	F_Cost = GetFieldViewCost ( inX - 1 - NoShift, inY + 1);
	Money = max ( visible [4], visible [5] );
	visible [15] = Money - F_Cost;
	if ( Money > 0 )
	{
		outX [outCount] = inX - 1 - NoShift;
		outY [outCount] = inY + 1;
		outCount ++;
	};
	//	Feld 16
	F_Cost = GetFieldViewCost ( inX - 2, inY);
	Money = visible [5];
	visible [16] = Money - F_Cost;
	if ( Money > 0 )
	{
		outX [outCount] = inX - 2;
		outY [outCount] = inY;
		outCount ++;
	};
	//	Feld 17
	F_Cost = GetFieldViewCost ( inX - 1 - NoShift, inY - 1);
	Money = max ( visible [5], visible [6] );
	visible [17] = Money - F_Cost;
	if ( Money > 0 )
	{
		outX [outCount] = inX - 1 - NoShift;
		outY [outCount] = inY - 1;
		outCount ++;
	};
	//	Feld 18
	F_Cost = GetFieldViewCost ( inX - 1, inY - 2);
	Money = visible [6];
	visible [18] = Money - F_Cost;
	if ( Money > 0 )
	{
		outX [outCount] = inX - 1;
		outY [outCount] = inY - 2;
		outCount ++;
	};
	//	Entfernung 3
	//	Feld 19
	if ( max ( visible [18], visible [7] ) > 0 )
	{
		outX [outCount] = inX - NoShift;
		outY [outCount] = inY - 3;
		outCount ++;
	};
	//	Feld 20
	if ( max ( visible [7], visible [8] ) > 0 )
	{
		outX [outCount] = inX + Shift;
		outY [outCount] = inY - 3;
		outCount ++;
	};
	//	Feld 21
	if ( visible [8] > 0 )
	{
		outX [outCount] = inX + 1 + Shift;
		outY [outCount] = inY - 3;
		outCount ++;
	};
	//	Feld 22
	if ( max ( visible [8], visible [9] ) > 0 )
	{
		outX [outCount] = inX + 2;
		outY [outCount] = inY - 2;
		outCount ++;
	};
	//	Feld 23
	if ( max ( visible [9], visible [10] ) > 0 )
	{
		outX [outCount] = inX + 2 + Shift;
		outY [outCount] = inY - 1;
		outCount ++;
	};
	//	Feld 24
	if ( visible [10] > 0 )
	{
		outX [outCount] = inX + 3;
		outY [outCount] = inY;
		outCount ++;
	};
	//	Feld 25
	if ( max ( visible [10], visible [11] ) > 0 )
	{
		outX [outCount] = inX + 2 + Shift;
		outY [outCount] = inY + 1;
		outCount ++;
	};
	//	Feld 26
	if ( max ( visible [11], visible [12] ) > 0 )
	{
		outX [outCount] = inX + 2;
		outY [outCount] = inY + 2;
		outCount ++;
	};
	//	Feld 27
	if ( visible [12] > 0 )
	{
		outX [outCount] = inX + 1 + Shift;
		outY [outCount] = inY + 3;
		outCount ++;
	};
	//	Feld 28
	if ( max ( visible [12], visible [13] ) > 0 )
	{
		outX [outCount] = inX + Shift;
		outY [outCount] = inY + 3;
		outCount ++;
	};
	//	Feld 29
	if ( max ( visible [13], visible [14] ) > 0 )
	{
		outX [outCount] = inX - NoShift;
		outY [outCount] = inY + 3;
		outCount ++;
	};
	//	Feld 30
	if ( visible [14] > 0 )
	{
		outX [outCount] = inX - 1 - NoShift;
		outY [outCount] = inY + 3;
		outCount ++;
	};
	//	Feld 31
	if ( max ( visible [14], visible [15] ) > 0 )
	{
		outX [outCount] = inX - 2;
		outY [outCount] = inY + 2;
		outCount ++;
	};
	//	Feld 32
	if ( max ( visible [15], visible [16] ) > 0 )
	{
		outX [outCount] = inX - 2 - NoShift;
		outY [outCount] = inY + 1;
		outCount ++;
	};
	//	Feld 33
	if ( visible [16] > 0 )
	{
		outX [outCount] = inX - 3;
		outY [outCount] = inY;
		outCount ++;
	};
	//	Feld 34
	if ( max ( visible [16], visible [17] ) > 0 )
	{
		outX [outCount] = inX - 2 - NoShift;
		outY [outCount] = inY - 1;
		outCount ++;
	};
	//	Feld 35
	if ( max ( visible [17], visible [18] ) > 0 )
	{
		outX [outCount] = inX - 2;
		outY [outCount] = inY - 2;
		outCount ++;
	};
	//	Feld 36
	if ( visible [18] > 0 )
	{
		outX [outCount] = inX - 1 - NoShift;
		outY [outCount] = inY - 3;
		outCount ++;
	};
};



// // // // // // // // // // // // // // // //
//
//	ReportChangedField
//

void Communicator :: ReportChangedField (
	int inChangeX,
	int inChangeY,
	unsigned int inIgnoreID )
{
	//	Parametercheck:
	if ( ObjektFeld == NULL )
		return;
		
	//	Ermittle Felder, von denen aus die Position
	//	sichtbar ist:
	int X [37];
	int Y [37];
	unsigned int Count;
	GetAllVisibleFields (
		inChangeX,
		inChangeY,
		X,
		Y,
		Count );

	//	Bestimme Adressatenliste:
	int sMaxSpieler = SpielerListe . CountElements () + 2;
	bool * sSpielerID = new bool [ sMaxSpieler ];
	if ( sSpielerID == NULL )
		return;
	int sRun;
	for ( sRun = 0; sRun < sMaxSpieler; sRun ++ )
		sSpielerID [ sRun ] = false;
	while ( Count > 0 )
	{
		Count --;
		sSpielerID [ GetSpielerID ( X [Count], Y [Count] ) ] = true;
	};
	ElementList Adressen;
	sRun = SpielerListe . CountElements ();
	while ( sRun > 0 )
	{
		sRun --;
		Spieler * sSpieler = (Spieler*) SpielerListe . GetElement ( sRun );
		if ( ( sSpieler -> alive ) && sSpielerID [ sSpieler -> DieID ]
		    && ( sSpieler -> DieID != inIgnoreID ) )
			Adressen . Insert ( (Element*) sSpieler );
	};
	delete [] sSpielerID;
	
	/*
	//	Durchlaufe das Positionsfeld,
	//	und bestimme die Zuschauer-Liste:
	ElementList Zuschauer;
	int sMyRun17;
	unsigned int sLastBelongsToID = 0;
	while ( Count > 0 )	
	{
		Count --;
		if ( GetFieldType ( X [Count], Y [Count] ) != FT_EndOfWorld )
		{
			ElementList * sHierObjekte = & ObjektFeld [ X [Count] + Width * Y [Count] ];
			sMyRun17 = sHierObjekte -> CountElements ();
			while ( sMyRun17 > 0 )
			{
				sMyRun17--;
				Objekt * sGaffer = (Objekt*) ( sHierObjekte -> GetElement ( sMyRun17 ) );
				unsigned int sThisBelongsToID = sGaffer -> BelongsTo;
				if ( ( sThisBelongsToID != sLastBelongsToID )
					&& ( sThisBelongsToID != inIgnoreID )
					&& ( sThisBelongsToID >= 2 ) )	//	keine Natives
				{
					//	interessanter Gaffer gefunden.
					Zuschauer . Insert ( sGaffer );
					sLastBelongsToID = sThisBelongsToID;
				};
			};
		};
	};
	
	//	und bestimme die Adressaten-Liste:
	ElementList Adressen;
	sMyRun17 = Zuschauer . CountElements ();
	while ( sMyRun17 > 0 )	
	{
		sMyRun17 --;
		unsigned int sID = ( (Objekt*) Zuschauer . GetElement ( sMyRun17 ) ) -> BelongsTo;
		//	Zuschauer gefunden.
		//	Durchlaufe SpielerListe:
		int SpListPos = SpielerListe . CountElements ();
		while ( SpListPos > 0 )
		{
			SpListPos--;
			Spieler * Found = (Spieler*) ( SpielerListe . GetElement ( SpListPos ) );
			if (( Found -> DieID == sID ) && ( Found -> alive ))
				//	Spieler mit korrekter ID gefunden.
				if ( ! Adressen . HasElement ( Found ) )
					//	Spieler ist noch nicht in Mail-Liste.
					Adressen . Insert ( Found );
		};
	};
	Zuschauer . MakeEmpty ();
	*/
	
	//	Gibts überhaupt nen Adressaten?
	if ( Adressen . CountElements() == 0 )
		return;
	
	//	Erstelle Standard Message:
	BMessage dieNachricht( Msg_InterApplicationMessage );
	dieNachricht . AddString("Type","status");
	
	//	Erstelle die Feld-Message:
	BMessage* Included = new BMessage ();
	if ( Included != NULL )
	{
		Included -> AddInt32 ( "XPos", inChangeX );
		Included -> AddInt32 ( "YPos", inChangeY );
		Included -> AddInt32 ( "Type", GetFieldType ( inChangeX, inChangeY ) );
		dieNachricht . AddMessage ( "Field", Included );
		delete Included;
	};
	
	//	Erstelle die Objekt-Messages:
	AddObjectsToMessage ( inChangeX, inChangeY, false, & dieNachricht );
	
	//	Aktuelle Uhrzeit:
	dieNachricht . AddInt64("CurrentTime", real_time_clock_usecs() );
						
	//	Durchlaufe die Adressatenliste:
	int AdListPos = Adressen . CountElements ();
	while ( AdListPos > 0 )
	{
		AdListPos --;
		Spieler * Adressat = (Spieler*) (Adressen . GetElement ( AdListPos ));
		
		BMessage* Duplikat = new BMessage ( dieNachricht );
		if ( Duplikat != NULL )
		{
			//	Dulikat erstellt.
			Duplikat -> AddString("ClientName", Adressat -> DerName);
			if ( Adressat -> readOnly )
				Duplikat -> AddString("Password", Adressat -> DasReadOnlyPasswort);
			else
				Duplikat -> AddString("Password", Adressat -> DasPasswort);
					
			//	Message verschicken:
			if ( Adressat -> DerBote . IsValid() )
				Adressat -> DerBote . SendMessage ( Duplikat );
			else
				Adressat -> alive = false;
				
			delete Duplikat;
		};
	};
};



// // // // // // // // // // // // // // // //
//
//	AddObjectsToMessage
//

void Communicator :: AddObjectsToMessage
	( int inX, int inY, bool inCompleteSensorData, BMessage* inMsg )
{
	if ( ObjektFeld == NULL )
		return;
	if ( GetFieldType ( inX, inY ) == FT_EndOfWorld )
		return;
	int sListe = inX + Karte :: Width * inY;
	int sPos = ObjektFeld [ sListe ] . CountElements ();
	while ( sPos > 0 )
	{
		sPos --;
		Objekt* sObj = (Objekt*) ( ObjektFeld [ sListe ] . GetElement ( sPos ));
		
		//	Erstelle BMessage:
		BMessage sMsg;
		sMsg . AddInt32 ( "ID", sObj -> GetID () );
		sMsg . AddInt32 ( "Type", sObj -> Typ );
		sMsg . AddInt32 ( "Owner", sObj -> BelongsTo );
		sMsg . AddInt64 ( "BusyTill", sObj -> BusyTill );
		sMsg . AddInt32 ( "XPos", sObj -> XPos );
		sMsg . AddInt32 ( "YPos", sObj -> YPos );
		sMsg . AddBool ( "SensorData", inCompleteSensorData );
		inMsg -> AddMessage ( "Object", & sMsg );
	};
};



// // // // // // // // // // // // // // // //
//
//	ReportMove
//

void Communicator :: ReportMove (
	int inFromX,
	int inFromY,
	int inToX,
	int inToY,
	unsigned int inID )
{
	//	Ermittle die sichtbaren Felder:
	int HideX [37];
	int HideY [37];
	unsigned int HideCount;
	GetAllVisibleFields (
		inFromX,
		inFromY,
		HideX,
		HideY,
		HideCount );
	int ShowX [37];
	int ShowY [37];
	unsigned int ShowCount;
	GetAllVisibleFields (
		inToX,
		inToY,
		ShowX,
		ShowY,
		ShowCount );
		
	//	Lösche die Schnittmenge aus
	//	der Hide-Liste:
	int i = ShowCount;
	while ( i > 0 )
	{
		i--;
		//	Suche Show-Feld in Hide-Liste:
		int j = HideCount;
		while ( j > 0 )
		{
			j--;
			
			if (( ShowX [i] == HideX [j] ) && ( ShowY [i] == HideY [j] ))
			{
				//	Show-Feld gefunden, das in Hide-Liste ist.
				//	Lösche es aus Hide-Liste:
				HideCount --;
				HideX [j] = HideX [HideCount];
				HideY [j] = HideY [HideCount];
			};
		};
	};
	
	//	Lösche aus der Hide-Liste, was sichtbar ist:
	i = HideCount;
	while ( i > 0 )
	{
		i--;
		
		//	Ermittle, von wo man das i-te Hide-Feld sieht:
		int SpannerX [37];
		int SpannerY [37];
		unsigned int SpannerCount;
		GetAllVisibleFields (
			HideX [i],
			HideY [i],
			SpannerX,
			SpannerY,
			SpannerCount );
			
		//	Ermittle, wer das i-te Hide-Feld sieht:
		bool invisible = true;
		while (( SpannerCount > 0 ) && ( invisible ))
		{
			SpannerCount --;
			
			//	Zuschauer auf aktuellem Feld?
			if ( GetSpielerID ( SpannerX [SpannerCount], SpannerY [SpannerCount]) == inID )
			{
				invisible = false;
			};
		};
		
		if ( ! invisible )
		{
			//	sichtbar.
			//	lösche aus Hide-Liste:
			HideCount --;
			HideX [i] = HideX [HideCount];
			HideY [i] = HideY [HideCount];
		};
	};
	
	//	Bestimme die Adressaten-Liste:
	ElementList Adressen;
	//	Durchlaufe SpielerListe:
	int SpListPos = SpielerListe . CountElements ();
	while ( SpListPos > 0 )
	{
		SpListPos--;
		Spieler * Found = (Spieler*) ( SpielerListe . GetElement ( SpListPos ) );
		if (( Found -> DieID == inID ) && ( Found -> alive ) )
			//	Spieler mit korrekter ID gefunden.
			Adressen . Insert ( (Element*) Found );
	};
	
	//	Gibts nen Adressaten?
	if ( Adressen . CountElements () == 0 )
		return;
	Spieler* Adressat =  (Spieler*) ( Adressen . GetElement ( 0 ) );
	
	//	Erstelle Message:
	BMessage dieNachricht( Msg_InterApplicationMessage );
	dieNachricht . AddString("Type","status");
	dieNachricht . AddString("ClientName", Adressat -> DerName);
					
	//	Erstelle die Feld-Messages:
	while ( HideCount > 0 )
	{
		HideCount --;
		BMessage Included;
		Included . AddInt32 ( "XPos", HideX [HideCount] );
		Included . AddInt32 ( "YPos", HideY [HideCount] );
		Included . AddInt32 ( "Type", FT_Invisible );
		dieNachricht . AddMessage ( "Field", & Included );
	};
	while ( ShowCount > 0 )
	{
		ShowCount --;
		BMessage Included2;
		Included2 . AddInt32 ( "XPos", ShowX [ShowCount] );
		Included2 . AddInt32 ( "YPos", ShowY [ShowCount] );
		Included2 . AddInt32 ( "Type",
			GetFieldType ( ShowX [ShowCount], ShowY [ShowCount] ) );
		dieNachricht . AddMessage ( "Field", & Included2 );
		
		//	Objekte zu sichtbaren Feldern addieren:
		AddObjectsToMessage (
			ShowX [ShowCount],
			ShowY [ShowCount],
			( ( ShowX [ShowCount] == inToX ) && ( ShowY [ShowCount] == inToY ) ),
			& dieNachricht );
	};
	
	//	Aktuelle Uhrzeit:
	dieNachricht . AddInt64("CurrentTime", real_time_clock_usecs() );
	
	//	Durchlaufe die Adressatenliste:
	int AdListPos = Adressen . CountElements ();
	while ( AdListPos > 0 )
	{
		AdListPos --;
		Adressat = (Spieler*) (Adressen . GetElement ( AdListPos ));
		
		//	Korrektes Passwort einfügen:
		if ( Adressat -> readOnly )
			dieNachricht . AddString("Password", Adressat -> DasReadOnlyPasswort);
		else
			dieNachricht . AddString("Password", Adressat -> DasPasswort);
		
		//	Message verschicken:
		if ( Adressat -> DerBote . IsValid() )
			Adressat -> DerBote . SendMessage ( & dieNachricht );
		else
			Adressat -> alive = false;
			
		//	Passwort löschen:
		dieNachricht . RemoveName( "Password" );		
	};
};



// // // // // // // // // // // // // // // //
//
//	ReportEverything
//

void Communicator :: ReportEverything ( Spieler * inNeuerSpieler )
{
	//	Parametercheck
	if ( inNeuerSpieler == NULL )
		return;
		
	//	erstelle Karte:
	Karte * ClientMap = new Karte ( ( Karte :: Width + 1 ) / 2 );
	if ( ClientMap == NULL )
		return;
		
	//	Spieler-ID bestimmen:
	unsigned int sID = inNeuerSpieler -> DieID;
	
	//	Kopiere alle sichtbaren Felder 
	//	vom Server zur Client-Map:
	int x;
	int y;
	for ( x = 0; x < Karte :: Width; x++ )
		for ( y = 0; y < Karte :: Height; y++ )
			if ( GetSpielerID ( x, y ) == sID )
			{
				//	Ermittle die sichtbaren Felder:
				unsigned int Anzahl;
				int XList [37];
				int YList [37];
				GetAllVisibleFields ( x, y, XList, YList, Anzahl );
				
				//	Kopiere Felder:
				while ( Anzahl > 0 )
				{
					Anzahl --;
					ClientMap -> SetFieldType (
						XList [Anzahl],
						YList [Anzahl],
						GetFieldType ( XList [Anzahl], YList [Anzahl] ) );
				};
			};
		
	//	Erstelle Message:
	BMessage dieNachricht( Msg_InterApplicationMessage );
	dieNachricht . AddString("Type","status");
	dieNachricht . AddString("ClientName", inNeuerSpieler -> DerName);
	if ( inNeuerSpieler -> readOnly )
		dieNachricht . AddString("Password", inNeuerSpieler -> DasReadOnlyPasswort);
	else
		dieNachricht . AddString("Password", inNeuerSpieler -> DasPasswort);
					
	//	Erstelle die Feld-Messages:
	for ( x = 0; x < Karte :: Width; x++ )
		for ( y = 0; y < Karte :: Height; y++ )
		{
			int sFType = ClientMap -> GetFieldType ( x, y );
			if ( ( sFType != FT_EndOfWorld ) && ( sFType != FT_Undiscovered ) )
			{
				BMessage Included2;
				Included2 . AddInt32 ( "XPos", x );
				Included2 . AddInt32 ( "YPos", y );
				Included2 . AddInt32 ( "Type", sFType );
				dieNachricht . AddMessage ( "Field", & Included2 );
				
				//	Objekte zu sichtbaren Feldern addieren:
				AddObjectsToMessage (
					x,
					y,
					GetSpielerID ( x, y ) == inNeuerSpieler -> DieID,
					& dieNachricht );
			};
		};
	
	//	Aktuelle Uhrzeit:
	dieNachricht . AddInt64("CurrentTime", real_time_clock_usecs() );
	
	//	Message verschicken:
	if ( inNeuerSpieler -> DerBote . IsValid() )
		inNeuerSpieler -> DerBote . SendMessage ( & dieNachricht );
	else
		inNeuerSpieler -> alive = false;
	
	//	Speicher freigeben:
	delete ClientMap;
};



// // // // // // // // // // // // // // // //
//
//	ReportVictory
//

void Communicator :: ReportVictory (
	unsigned int inID,
	const char * inName )
{
	//	Erstelle Standard Message:
	BMessage dieNachricht( Msg_InterApplicationMessage );
	dieNachricht . AddString( "Type", "victory" );
	dieNachricht . AddInt32( "ID", inID );
	dieNachricht . AddString( "Name", inName );
	
	//	durchlaufe Spielerliste:
	int sListPos = SpielerListe . CountElements ();
	while ( sListPos > 0 )
	{
		//	Ermittle Spieler:
		sListPos --;
		Spieler * sFinger = (Spieler*) ( SpielerListe . GetElement ( sListPos ) );
		
		if ( sFinger -> alive )
		{
			//	Spieler lebt noch.
			
			//	Mache Message fertig:
			dieNachricht . AddString( "ClientName", sFinger -> DerName );
			if ( sFinger -> readOnly )
				dieNachricht . AddString( "Password", sFinger -> DasReadOnlyPasswort );
			else
				dieNachricht . AddString( "Password", sFinger -> DasPasswort );

			//	verschicke Message:
			if ( sFinger -> DerBote . IsValid() )
				sFinger -> DerBote . SendMessage ( & dieNachricht );
			else
				sFinger -> alive = false;
			
			//	Mache änderungen an message rückgängig:
			dieNachricht . RemoveName ( "ClientName" );
			dieNachricht . RemoveName ( "Password" );
		};
	};
};



//
//	Ende
//
// // // // // // // // // // // // // // // //